<?php
/**
 * Routes configuration
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different urls to chosen controllers and their actions (functions).
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.app.config
 * @since         CakePHP(tm) v 0.2.9
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
/**
 * Here, we are connecting '/' (base path) to controller called 'Pages',
 * its action called 'display', and we pass a param to select the view file
 * to use (in this case, /app/views/pages/home.ctp)...
 */
	Router::connect('/', array('controller' => 'videos', 'action' => 'index', 'home'));
	Router::connect('/videos/:video-title/:video-id', array('controller' => 'videos', 'action' => 'view'),array('pass' => array('video-title','video-id'),'video-title' => '[0-9a-zA-Z-]+','video-id' => '[0-9]+'));
	Router::connect('/videos/:video-title/:video-id/:page', array('controller' => 'videos', 'action' => 'view'),array('pass' => array('video-title','video-id'),'video-title' => '[0-9a-zA-Z-]+','video-id' => '[0-9]+'));
	Router::connect('/recent', array('controller' => 'videos', 'action' => 'videos_by_type', 'recent'));
	Router::connect('/recent/:page', array('controller' => 'videos', 'action' => 'videos_by_type', 'recent'));
	Router::connect('/most-viewed', array('controller' => 'videos', 'action' => 'videos_by_type', 'most_viewed'));
	Router::connect('/most-viewed/:page', array('controller' => 'videos', 'action' => 'videos_by_type', 'most_viewed'));
	Router::connect('/categories/:category-name/:category-id', array('controller' => 'categories', 'action' => 'video_by_category'),array('pass' => array('category-name','category-id'),'category-name' => '[0-9a-zA-Z-]+','category-id' => '[0-9]+'));
	Router::connect('/categories/:category-name/:category-id/:page', array('controller' => 'categories', 'action' => 'video_by_category'),array('pass' => array('category-name','category-id','page'),'category-name' => '[0-9a-zA-Z-]+','category-id' => '[0-9]+','page' => '[0-9]+'));
	
	Router::connect('/search_results/:keyword', array('controller' => 'videos', 'action' => 'search_results'),array('pass' => array('keyword'),'keyword' => '[a-zA-Z0-9]+'));	
	Router::connect('/search_results/:keyword/:page', array('controller' => 'videos', 'action' => 'search_results'),array('pass' => array('keyword'),'keyword' => '[a-zA-Z0-9]+','page' => '[0-9]+'));
	
	Router::connect('/signup', array('controller' => 'users', 'action' => 'signup'));	
	Router::connect('/login', array('controller' => 'users', 'action' => 'login'));
	Router::connect('/logout', array('controller' => 'users', 'action' => 'logout'));
	Router::connect('/forgot-password', array('controller' => 'users', 'action' => 'forgot'));
	Router::connect('/change-password', array('controller' => 'users', 'action' => 'changepassword'));
	
/**
 * ...and connect the rest of 'Pages' controller's urls.
 */
	Router::connect('/pages/*', array('controller' => 'pages', 'action' => 'display'));
	
	
	Router::connect('/box_categories/box', array('controller' => 'categories', 'action' => 'box'));
	
	Router::connect('/admin/settings/view', array('controller' => 'settings', 'action' => 'view','admin' => 'admin'));	
	Router::connect('/admin/settings/edit/:id', array('controller' => 'settings', 'action' => 'edit','admin' => 'admin'),array('pass' => array('id')));	
	
	Router::connect('/admin/comments/view', array('controller' => 'comments', 'action' => 'view','admin' => 'admin'));	
	Router::connect('/admin/comments/edit/:id', array('controller' => 'comments', 'action' => 'edit','admin' => 'admin'),array('pass' => array('id')));	
	
	Router::connect('/admin/users/view', array('controller' => 'users', 'action' => 'view','admin' => 'admin'));	
	Router::connect('/admin/users/edit/:id', array('controller' => 'users', 'action' => 'edit','admin' => 'admin'),array('pass' => array('id')));	
	
	
	Router::connect('/admin/videos/view', array('controller' => 'videos', 'action' => 'view','admin' => 'admin'));	
	Router::connect('/admin/videos/delete/:id', array('controller' => 'videos', 'action' => 'delete','admin' => 'admin'),array('pass' => array('id')));	
	Router::connect('/admin/videos/add', array('controller' => 'videos', 'action' => 'add','admin' => 'admin'));	
	Router::connect('/admin/videos/edit/:id', array('controller' => 'videos', 'action' => 'edit','admin' => 'admin'),array('pass' => array('id')));	
	
	Router::connect('/admin/categories/view', array('controller' => 'categories', 'action' => 'view','admin' => 'admin'));	
	Router::connect('/admin/categories/delete/:id', array('controller' => 'categories', 'action' => 'delete','admin' => 'admin'),array('pass' => array('id')));	
	Router::connect('/admin/categories/add', array('controller' => 'categories', 'action' => 'add','admin' => 'admin'));	
	Router::connect('/admin/categories/edit/:id', array('controller' => 'categories', 'action' => 'edit','admin' => 'admin'),array('pass' => array('id')));	
	